<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\TetsController;
//ADMIN
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\GuestController;
//CMS
use App\Http\Controllers\Cms\CmsLogsController;
use App\Http\Controllers\Cms\CmsMenusAccessController;
use App\Http\Controllers\Cms\CmsMenusController;
use App\Http\Controllers\Cms\CmsModulesController;
use App\Http\Controllers\Cms\CmsSettingsController;
use App\Http\Controllers\Cms\RoleController;
use App\Http\Controllers\Cms\CmsRoleAccessController;
use App\Http\Controllers\Cms\UsersController;
use App\Http\Controllers\Cms\CmsMenusDetailController;
use App\Http\Controllers\Cms\CmsEmailsController;
use App\Http\Controllers\Cms\CmsDocumentController;
use App\Http\Controllers\Cms\CmsManagementUsersController;

// SPIN WHEEEL
use App\Http\Controllers\Wheel\DrawController;
use App\Http\Controllers\Wheel\HistoryController;
use App\Http\Controllers\Wheel\PrizeController;
use App\Http\Controllers\Wheel\SpinController;
use App\Http\Controllers\Wheel\VoucherController;
use App\Http\Controllers\Wheel\ContentController;
use App\Http\Controllers\Wheel\FaqController;
use App\Http\Controllers\Wheel\MemberController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/',[SpinController::class, 'index'])->name('index');
Route::get('result/{draw_id}/{prize_id}',[SpinController::class, 'result']);
Route::post('spin',[SpinController::class, 'store']);


Route::middleware(['web'])->group(function () {

    Route::group(['middleware' => ['auth']], function () {

        Route::get("account",[CmsManagementUsersController::class,"account"]);
        Route::get("password",[CmsManagementUsersController::class,"password"]);
        Route::post("account/update",[CmsManagementUsersController::class,"account_update"]);
        Route::post("password/update",[CmsManagementUsersController::class,"password_update"]);

        Route::group(['prefix' => 'admin','middleware' => ['admin']], function () {

            Route::get('content',[ContentController::class, 'index']);
            Route::get('content/create',[ContentController::class, 'create']);
            Route::get('content/show/{id}',[ContentController::class, 'show']);
            Route::get('content/edit/{id}',[ContentController::class, 'edit']);
            Route::post('content/store',[ContentController::class, 'store']);
            Route::post('content/update',[ContentController::class, 'update']);
            Route::get('content/destroy/{id}',[ContentController::class, 'destroy']);

            Route::get('draw',[DrawController::class, 'index']);
            Route::get('draw/create',[DrawController::class, 'create']);
            Route::get('draw/show/{id}',[DrawController::class, 'show']);
            Route::get('draw/edit/{id}',[DrawController::class, 'edit']);
            Route::post('draw/store',[DrawController::class, 'store']);
            Route::post('draw/update',[DrawController::class, 'update']);
            Route::get('draw/destroy/{id}',[DrawController::class, 'destroy']);

            Route::get('prize',[PrizeController::class, 'index']);
            Route::get('prize/create',[PrizeController::class, 'create']);
            Route::get('prize/show/{id}',[PrizeController::class, 'show']);
            Route::get('prize/edit/{id}',[PrizeController::class, 'edit']);
            Route::post('prize/store',[PrizeController::class, 'store']);
            Route::post('prize/update',[PrizeController::class, 'update']);
            Route::get('prize/destroy/{id}',[PrizeController::class, 'destroy']);

            Route::get('voucher',[VoucherController::class, 'index']);
            Route::get('voucher/create',[VoucherController::class, 'create']);
            Route::get('voucher/show/{id}',[VoucherController::class, 'show']);
            Route::get('voucher/edit/{id}',[VoucherController::class, 'edit']);
            Route::post('voucher/store',[VoucherController::class, 'store']);
            Route::post('voucher/save',[VoucherController::class, 'save']);
            Route::post('voucher/update',[VoucherController::class, 'update']);
            Route::get('voucher/destroy/{id}',[VoucherController::class, 'destroy']);

            Route::get('faq',[FaqController::class, 'index']);
            Route::get('faq/create',[FaqController::class, 'create']);
            Route::get('faq/show/{id}',[FaqController::class, 'show']);
            Route::get('faq/edit/{id}',[FaqController::class, 'edit']);
            Route::post('faq/store',[FaqController::class, 'store']);
            Route::post('faq/update',[FaqController::class, 'update']);
            Route::get('faq/destroy/{id}',[FaqController::class, 'destroy']);

            Route::get('member',[MemberController::class, 'index']);
            Route::get('member/create',[MemberController::class, 'create']);
            Route::get('member/show/{id}',[MemberController::class, 'show']);
            Route::get('member/edit/{id}',[MemberController::class, 'edit']);
            Route::post('member/store',[MemberController::class, 'store']);
            Route::post('member/update',[MemberController::class, 'update']);
            Route::get('member/destroy/{id}',[MemberController::class, 'destroy']);

            Route::get('history/destroy/{id}',[HistoryController::class, 'destroy']);

        });

    });

});


//ROUTE UNTUK ADMIN DAN SUPER ADMIN DEFAULT

Route::middleware(['web'])->group(function () {

    Route::group(['middleware' => ['auth']], function () {

        Route::get('dashboard',[DashboardController::class, 'index'])->name('dashboard');
        Route::get('dashboard_all',[DashboardController::class, 'all']);

        Route::get('test',[TetsController::class, 'index']);

        Route::post('logout',[AuthController::class, 'logout']);   

        Route::group(['prefix' => 'admin','middleware' => ['admin']], function () {

            Route::get('role',[RoleController::class, 'index'])->name('role');
            Route::get('role/create',[RoleController::class, 'create'])->name('role-create');
            Route::get('role/show/{id}',[RoleController::class, 'show'])->name('role-show');
            Route::get('role/edit/{id}',[RoleController::class, 'edit'])->name('role-edit');
            Route::get('role/destroy/{id}',[RoleController::class, 'destroy'])->name('role-destroy');
            Route::post('role/store',[RoleController::class, 'store'])->name('role-store');
            Route::post('role/update',[RoleController::class, 'update'])->name('role-update');
            Route::post('role/action/{slug}/{id}',[RoleController::class, 'action']);


            Route::get('users',[UsersController::class, 'index'])->name('users');
            Route::get('users/create',[UsersController::class, 'create'])->name('users-create');
            Route::get('users/show/{id}',[UsersController::class, 'show'])->name('users-show');
            Route::get('users/edit/{id}',[UsersController::class, 'edit'])->name('users-edit');
            Route::get('users/destroy/{id}',[UsersController::class, 'destroy'])->name('users-destroy');
            Route::post('users/store',[UsersController::class, 'store'])->name('users-store');
            Route::post('users/update',[UsersController::class, 'update'])->name('users-update');
            Route::post('users/action/{slug}/{id}',[UsersController::class, 'action']);


            Route::get('logs',[CmsLogsController::class, 'index'])->name('logs');

            Route::get('settings',[CmsSettingsController::class, 'index'])->name('settings');
            Route::get('settings/create',[CmsSettingsController::class, 'create'])->name('settings-create');
            Route::get('settings/show/{id}',[CmsSettingsController::class, 'show'])->name('settings-show');
            Route::get('settings/edit/{id}',[CmsSettingsController::class, 'edit'])->name('settings-edit');
            Route::get('settings/destroy/{id}',[CmsSettingsController::class, 'destroy'])->name('settings-destroy');
            Route::post('settings/store',[CmsSettingsController::class, 'store'])->name('settings-store');
            Route::post('settings/update',[CmsSettingsController::class, 'update'])->name('settings-update');
            Route::post('settings/action/{slug}/{id}',[CmsSettingsController::class, 'action']);

            Route::get('role_access/{role_id}', [CmsRoleAccessController::class, 'index']);
            Route::post('role_access/store', [CmsRoleAccessController::class, 'store']);

            Route::group(['middleware' => ['superadmin']], function () {

                    Route::get('modules',[CmsModulesController::class, 'index'])->name('modules');
                    Route::get('modules/create',[CmsModulesController::class, 'create'])->name('modules-create');
                    Route::get('modules/show/{id}',[CmsModulesController::class, 'show'])->name('modules-show');
                    Route::get('modules/edit/{id}',[CmsModulesController::class, 'edit'])->name('modules-edit');
                    Route::get('modules/destroy/{id}',[CmsModulesController::class, 'destroy'])->name('modules-destroy');
                    Route::post('modules/store',[CmsModulesController::class, 'store'])->name('modules-store');
                    Route::post('modules/update',[CmsModulesController::class, 'update'])->name('modules-update');
                    Route::post('modules/action/{slug}/{id}',[CmsModulesController::class, 'action']);
                    Route::get('modules/generate/{id}',[CmsModulesController::class, 'generate'])->name('modules-generate');

                    Route::get('menus',[CmsMenusController::class, 'index'])->name('menus');
                    Route::get('menus/create',[CmsMenusController::class, 'create'])->name('menus-create');
                    Route::get('menus/show/{id}',[CmsMenusController::class, 'show'])->name('menus-show');
                    Route::get('menus/edit/{id}',[CmsMenusController::class, 'edit'])->name('menus-edit');
                    Route::get('menus/destroy/{id}',[CmsMenusController::class, 'destroy'])->name('menus-destroy');
                    Route::post('menus/store',[CmsMenusController::class, 'store'])->name('menus-store');
                    Route::post('menus/update',[CmsMenusController::class, 'update'])->name('menus-update');
                    Route::get('menus/action/{id}',[CmsMenusController::class, 'action']);
                    Route::get('menus/status/{id}/{status}',[CmsMenusController::class, 'status']);

                    Route::get('menu_access/{cms_menus_id}',[CmsMenusAccessController::class, 'index']);
                    Route::get('menu_access/destroy/{id}',[CmsMenusAccessController::class, 'destroy']);
                    Route::post('menu_access/store',[CmsMenusAccessController::class, 'store']);

                    Route::get('menu_detail/{cms_menus_id}', [CmsMenusDetailController::class, 'index']);
                    Route::get('menu_detail/destroy/{id}', [CmsMenusDetailController::class, 'destroy']);
                    Route::post('menu_detail/store', [CmsMenusDetailController::class, 'store']);
                    Route::post('menu_detail/update', [CmsMenusDetailController::class, 'update']);


                    Route::get('emails',[CmsEmailsController::class, 'index'])->name('emails');
                    Route::get('emails/create',[CmsEmailsController::class, 'create'])->name('emails-create');
                    Route::get('emails/show/{id}',[CmsEmailsController::class, 'show'])->name('emails-show');
                    Route::get('emails/edit/{id}',[CmsEmailsController::class, 'edit'])->name('emails-edit');
                    Route::get('emails/destroy/{id}',[CmsEmailsController::class, 'destroy'])->name('emails-destroy');
                    Route::post('emails/store',[CmsEmailsController::class, 'store'])->name('emails-store');
                    Route::post('emails/update',[CmsEmailsController::class, 'update'])->name('emails-update');

                    Route::get('document',[CmsDocumentController::class, 'index'])->name('document');
            });

        });

    });

    

    Route::group(['middleware' => ['guest']], function () {
        Route::get('login',[GuestController::class, 'login'])->name('login');
        Route::get('register',[GuestController::class, 'register'])->name('register');
        Route::get('forget',[GuestController::class, 'forget'])->name('forget');
        //confirmasi email
        Route::get('verifikasi/{email}',[AuthController::class, 'validasiEmail']);

        Route::get('verifikasi',[GuestController::class, 'verifikasi'])->name('verifikasi');
    });

    Route::group(['middleware' => ['guest','throttle:6,1']], function () {

        Route::post('sign-in',[AuthController::class, 'login']);
        Route::post('sign-up',[AuthController::class, 'register']);
        Route::post('forget-password',[AuthController::class, 'forget_password']);


    });



});