@extends('web.tema.content')
@section('content')

 <!-- SOUND TRACK -->
 @if($spin=="false")

  <embed src="{{Fibonanci::content()['music']}}" loop="true" autostart="true" width="2" height="0" hidden>
    <audio controls autoplay hidden id="my_audio" loop="loop">
        <source src="{{Fibonanci::content()['music']}}" type="audio/mpeg">
        Your browser does not support the audio element.
  </audio>

@endif

  <div class="container">

    <div class="row d-flex align-items-center" style="height:100vh">
      <div class="text-center mb-2 logo-mobile">
        <img src="{{Fibonanci::content()['logo']}}" width="200px" alt="">
      </div>
      <div class="col-md-6 col-sm-12 text-center">
        @include('web.tema.wheel')
      </div>


      <div class="col-md-6 col-sm-12">

        <div class="text-center mb-5 logo-pc">
          <img src="{{Fibonanci::content()['logo']}}" width="200px" alt="">
        </div>
        <form class="row g-3" action="{{url('spin')}}" method="POST">
            @csrf
            <div class="col-md-12">
              <center>
                <input type="text" class="form-control width-form" id="voucher" name="voucher" placeholder="kupon / voucher" required>
              </center>
            </div>

            <div class="text-center">
                <input type="submit" value="SPIN" class="btn btn-primary width-form">
            </div>
        </form>
        
      </div>

    </div>
</div>

@push('js')

@if($spin == 'false')
    <script>
      var total    = {{ Js::from($total) }};
      var duration = {{ Js::from($duration) }};
      var start    = {{ Js::from($start) }};
      // Create new wheel object specifying the parameters at creation time.
      var theWheel = new Winwheel({
          'numSegments'       : 8,                 // Specify number of segments.
          'outerRadius'       : 200,               // Set outer radius so wheel fits inside the background.
          'drawText'          : false,              // Code drawn text can be used with segment images.
          'textFontSize'      : 16,
          'textOrientation'   : 'curved',
          'textAlignment'     : 'inner',
          'textMargin'        : 170,
          'textFontFamily'    : 'monospace',
          'textStrokeStyle'   : 'black',
          'textLineWidth'     : 3,
          'textFillStyle'     : 'white',
          'imageOverlay'      : false,
          'wheelImage'        : "{{Fibonanci::content()['outwheel']}}",
          'drawMode'          : 'segmentImage',    // Must be segmentImage to draw wheel using one image per segemnt.
          'segments'          :  hadiah,                // Define segments including image and text,
          'animation' :           // Specify the animation to use.
          {
              'type'     : 'spinOngoing',
              'duration' : duration,     // Duration in seconds.
              'spins'    : total,     // Number of complete spins.
              'stopAngle': start,
          }
      });

      // Vars used by the code in this page to do power controls.
      var wheelPower    = 0;
      var wheelSpinning = false;

      theWheel.startAnimation();
    </script>
@endif

@endpush
    
@endsection