<?php

namespace App\Models\Wheel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use App\Models\Wheel\SpinDraw;

class SpinVoucher extends Model
{
    use HasFactory;
    protected $table = 'spin_voucher';

    protected $fillable = [
        'id',
        'voucher',
        'status',
    ];

    public function getIncrementing()
    {
        return false;
    }

    /**
     * Get the auto-incrementing key type.
     *
     * @return string
     */
    public function getKeyType()
    {
        return 'string';
    }

    public static function listData(){
        $data = SpinVoucher::orderBy('spin_voucher.created_at','desc')
                ->get();

        return $data;
    }

    public static function listDataNotUsed(){
        $notused = SpinDraw::where('status','not used')->pluck('voucher_id');
        $data = SpinVoucher::where('spin_voucher.status','not used')
                    ->whereNotIn('id',$notused)
                    ->orderBy('spin_voucher.created_at','desc')->get();

        return $data;
    }

    public static function insertData($request){
        $data = SpinVoucher::create([
            'id' => (string) Str::uuid(),
            'voucher' => Str::random(6),
            'status' => 'not used',
        ]);

        return $data;
    }

    public static function updateData($request){
        $data = SpinVoucher::where('id',$request->id)->update([
            'voucher' => $request->voucher,
            'status' => $request->status,
        ]);

        return $data;
    }

    public static function detailData($id){
        $data = SpinVoucher::where('spin_voucher.id',$id)
                ->first();

        return $data;
    }

    public static function confirmData($member_id){
        $data = SpinVoucher::whereDate('spin_voucher.created_at',date('Y-m-d'))
                ->first();

        return $data;
    }
}
