<?php

namespace App\Models\Wheel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Helper;
use Storage;

class SpinContent extends Model
{
    use HasFactory;
    protected $table = 'spin_content';

    protected $fillable = [
        'id',
        'name',
        'wheel',
        'outwheel',
        'logo',
        'background',
        'favicon',
        'music',
        'music_win',
        'music_lose',
        'music_spin',
        'status',
    ];

    public function getIncrementing()
    {
        return false;
    }

    /**
     * Get the auto-incrementing key type.
     *
     * @return string
     */
    public function getKeyType()
    {
        return 'string';
    }

    public static function listData(){
        $data = SpinContent::orderBy('created_at','desc')->get();

        return $data;
    }

    public static function insertData($request){

        if($request->file('logo')){

            $data['logo']=Helper::image($request->file('logo'),'content');
        }

        if($request->file('wheel')){

            $data['wheel']=Helper::image($request->file('wheel'),'content');
        }

        if($request->file('outwheel')){

            $data['outwheel']=Helper::image($request->file('outwheel'),'content');
        }

        if($request->file('background')){

            $data['background']=Helper::image($request->file('background'),'content');
        }

        if($request->file('favicon')){

            $data['favicon']=Helper::image($request->file('favicon'),'content');
        }

        if($request->file('music')){

            $data['music']=Helper::image($request->file('music'),'content');
        }

        if($request->file('music_win')){

            $data['music_win']=Helper::image($request->file('music_win'),'content');
        }

        if($request->file('music_lose')){

            $data['music_lose']=Helper::image($request->file('music_lose'),'content');
        }

        if($request->file('music_spin')){

            $data['music_spin']=Helper::image($request->file('music_spin'),'content');
        }

        $data['name']   = $request->name;
        $data['status'] = $request->status;
        $data['id']     = (string) Str::uuid();

        $save = SpinContent::insert($data);

        return $save;

    }


    public static function updateData($request){

        $check=SpinContent::find($request->id);

        if($check->logo){
            if($request->file('logo')){
                Storage::delete('public/'.$check->logo);

                $data['logo']=Helper::image($request->file('logo'),'content');
            }
        }else{
            if($request->file('logo')){

                $data['logo']=Helper::image($request->file('logo'),'content');
            }
        }

        if($check->wheel){
            if($request->file('wheel')){
                Storage::delete('public/'.$check->wheel);

                $data['wheel']=Helper::image($request->file('wheel'),'content');
            }
        }else{
            if($request->file('wheel')){

                $data['wheel']=Helper::image($request->file('wheel'),'content');
            }
        }

        if($check->outwheel){
            if($request->file('outwheel')){
                Storage::delete('public/'.$check->outwheel);

                $data['outwheel']=Helper::image($request->file('outwheel'),'content');
            }
        }else{
            if($request->file('outwheel')){

                $data['outwheel']=Helper::image($request->file('outwheel'),'content');
            }
        }

        if($check->background){
            if($request->file('background')){
                Storage::delete('public/'.$check->background);

                $data['background']=Helper::image($request->file('background'),'content');
            }
        }else{
            if($request->file('background')){

                $data['background']=Helper::image($request->file('background'),'content');
            }
        }

        if($check->favicon){
            if($request->file('favicon')){
                Storage::delete('public/'.$check->favicon);

                $data['favicon']=Helper::image($request->file('favicon'),'content');
            }
        }else{
            if($request->file('favicon')){

                $data['favicon']=Helper::image($request->file('favicon'),'content');
            }
        }

        if($check->music){
            if($request->file('music')){
                Storage::delete('public/'.$check->music);

                $data['music']=Helper::image($request->file('music'),'content');
            }
        }else{
            if($request->file('music')){

                $data['music']=Helper::image($request->file('music'),'content');
            }
        }

        if($check->music_lose){
            if($request->file('music_lose')){
                Storage::delete('public/'.$check->music_lose);

                $data['music_lose']=Helper::image($request->file('music_lose'),'content');
            }
        }else{
            if($request->file('music_lose')){

                $data['music_lose']=Helper::image($request->file('music_lose'),'content');
            }
        }

        if($check->music_win){
            if($request->file('music_win')){
                Storage::delete('public/'.$check->music_win);

                $data['music_win']=Helper::image($request->file('music_win'),'content');
            }
        }else{
            if($request->file('music_win')){

                $data['music_win']=Helper::image($request->file('music_win'),'content');
            }
        }

        if($check->music_spin){
            if($request->file('music_spin')){
                Storage::delete('public/'.$check->music_spin);

                $data['music_spin']=Helper::image($request->file('music_spin'),'content');
            }
        }else{
            if($request->file('music_spin')){

                $data['music_spin']=Helper::image($request->file('music_spin'),'content');
            }
        }

        $data['name'] = $request->name;
        $data['status']= $request->status;

        $update = SpinContent::where('id',$request->id)->update($data);

        return $update;

    }
}
