<?php
namespace App\Helpers;

use Carbon\Carbon;
use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Http;
use Image;
 
use Illuminate\Support\Facades\DB;
 
class Date {
   
    public static function addDate($val){
        date_default_timezone_set('Asia/Jakarta');
        $date       = date('Y-m-d');
        $format     = str_replace('-', '/', $date);
        $result     = date('Y-m-d',strtotime($format . "+".$val." days"));

        return $result;
    }

    public static function minDate($val){
        $date = date('Y-m-d');
        $result = date('Y-m-d',(strtotime ( '-'.$val.' day' , strtotime ( $date) ) ));

        return $result;
    }

    public static function now(){

        return date('Y-m-d');
    }

    public static function getDatesFromRange($start, $end, $format = 'Y-m-d') {
      
        // Declare an empty array
        $array = array();
          
        // Variable that store the date interval
        // of period 1 day
        $interval = new DateInterval('P1D');
      
        $realEnd = new DateTime($end);
        $realEnd->add($interval);
      
        $period = new DatePeriod(new DateTime($start), $interval, $realEnd);
      
        // Use loop to store date into array
        foreach($period as $date) {                 
            $array[] = $date->format($format); 
        }
      
        // Return the array elements
        return $array;
    }
      
}