@extends('web.tema.content')
@section('content')

@if( $result_prize->status=='win')

    @push('js')

    <script>
        $(document).ready(function(){
        Swal.fire({
            icon: 'success',
            title: '{{str_replace(array("\r", "\n"), '', Nfs::content("notif_win")["title"])}}',
            html:'<p>{{str_replace(array("\r", "\n"), '', Nfs::content("notif_win")["description"])}}<p><br>'+
                '<b>code   : {{ $result_draw->voucher}}</b><br><br>' +
                '<b>prize  : {{ $result_prize->label }}</b>',
            footer: '<a href="{{url("/")}}">kembali ke menu</a>'
        })
    })
    </script>

        
    @endpush

@else
        @push('js')

        <script>
             $(document).ready(function(){
                Swal.fire({
                    icon: 'warning',
                    title: '{{str_replace(array("\r", "\n"), '', Nfs::content("notif_lose")["title"])}}',
                    text: '{{str_replace(array("\r", "\n"), '', Nfs::content("notif_lose")["description"])}}',
                    footer: '<a href="{{url("/")}}">kembali ke menu</a>'
                })
            })
        </script>
            
        @endpush

@endif

<div class="container">

    <div class="row d-flex align-items-center" style="height:100vh">
      <div class="col-sm-12">
        <div class="text-center mb-2">
            <img src="{{Fibonanci::content()['logo']}}" width="200px" alt="">
          </div>
            @include('web.tema.wheel')
      </div>

      <div class="col-sm-12">
        <div class="text-center">
            <a href="{{url("/")}}" class="btn btn-sm btn-primary">Kembali Ke Home</a>
        </div>
      </div>
    </div>
  </div>
  


@if($result_prize->status=='win')
    <audio autoplay="true" loop src="{{Fibonanci::content()['music_win']}}">
        Update your browser. Your browser does not support HTML audio
    </audio>
    <div class="hidden">
        <audio id="spinAudio" src="{{Fibonanci::content()['music_win']}}"></audio>
    </div>

    @push('js')
        <script>
            confetti.start();
        </script>
    @endpush
@else

    <audio autoplay="true" loop src="{{Fibonanci::content()['music_lose']}}">
        Update your browser. Your browser does not support HTML audio
    </audio>
    <div class="hidden">
        <audio id="spinAudio" src="{{Fibonanci::content()['music_lose']}}"></audio>
    </div>

@endif



@push('js')

<script>
    var total    = {{ Js::from($total) }};
    var rotation = {{ Js::from($rotation) }};
    // Create new wheel object specifying the parameters at creation time.
    var theWheel = new Winwheel({
        'numSegments'       : 8,                 // Specify number of segments.
        'outerRadius'       : 200,               // Set outer radius so wheel fits inside the background.
        'drawText'          : false,              // Code drawn text can be used with segment images.
        'textFontSize'      : 16,
        'textOrientation'   : 'curved',
        'textAlignment'     : 'inner',
        'textMargin'        : 170,
        'textFontFamily'    : 'monospace',
        'textStrokeStyle'   : 'black',
        'textLineWidth'     : 3,
        'textFillStyle'     : 'white',
        'imageOverlay'      : false,
        'wheelImage'        : "{{Fibonanci::content()['outwheel']}}",
        'drawMode'          : 'segmentImage',    // Must be segmentImage to draw wheel using one image per segemnt.
        'segments'          :  hadiah,                // Define segments including image and text,
        'animation' :           // Specify the animation to use.
          {
              'type'     : 'spinToStop',
              'duration' : 1,     // Duration in seconds.
              'spins'    : total,     // Number of complete spins.
              'stopAngle': rotation,
          }
    });

    theWheel.startAnimation();

</script>

@endpush


@endsection