<?php

namespace App\Http\Controllers\Wheel;

use App\Http\Controllers\Controller;
#PACKAGE
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Validator;
use Hash;
#HELPER
use Cron;
use Date;
use Fibonanci;
use Helper;
use Nfs;
use Payments;
use Wa;
#MODEL
use App\Models\User;
use App\Models\Cms\Role;
use App\Models\Cms\CmsLogs;

#WHEEL
use App\Models\Wheel\SpinContent;
use App\Models\Wheel\SpinDraw;
use App\Models\Wheel\SpinFaq;
use App\Models\Wheel\SpinHistory;
use App\Models\Wheel\SpinPrize;
use App\Models\Wheel\SpinVoucher;

class SpinController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        Nfs::insertLogs('Pengunjung Website');
        $data['title']   = 'Draw Spin';
        $data['faq']     = SpinFaq::listData();
        $data['history'] = SpinHistory::listData();
        $data['prize']   = SpinPrize::orderBy('sorter','asc')->get();
        $data['total']   = SpinPrize::count();
        $data['spin' ]   = "false";

        //animation  mememulai di halaman awal
        $data['duration'] = 200;
        $data['start']    = 380;
        return view('web.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'voucher'       => 'required|string',
        ]);

        $check = SpinVoucher::where('spin_voucher.voucher',$request->voucher)
                 ->first();

        if($check){

            if($check->status != 'used' ){

                $draw = SpinDraw::join('spin_voucher','spin_draw.voucher_id','=','spin_voucher.id')
                        ->where('spin_voucher.voucher',$request->voucher)
                        ->select('spin_draw.*')
                        ->first();

                if($draw){


                    if($draw->expired_date >= date('Y-m-d')){

                        //mengecek type

                        if($draw->type == 'presentase'){

                            $prize      = Fibonanci::presentase();

                            $rotation   = Fibonanci::rotation($prize['id']);

                            //update ticket
                            SpinVoucher::where('voucher',$request->voucher)->update([
                                "status" => 'used',
                            ]);

                            SpinDraw::where('id',$draw->id)->update([
                                "prize_id" => $prize['id'],
                                "rotation" => $rotation,
                                'status'   => 'used'
                            ]);

                            //save history
                            SpinHistory::create([
                                "id"        => (string) Str::uuid(),
                                "date"      => date('Y-m-d'),
                                "draw_id"   => $draw->id,
                                "prize_id"  => $prize['id']
                            ]);

                            //return to index

                            $data['faq']       = SpinFaq::listData();
                            $data['history']   = SpinHistory::listData();
                            $data['prize']     = SpinPrize::orderBy('sorter','asc')->get();
                            $data['total']     = SpinPrize::count();
                            $data['spin' ]     = "true";
                            $data['rotation']  = $rotation;
                            $data['result']    = $prize['id'];
                            $data['draw_id']   = $draw->id;
                            $data['duration']  = 20;

                            return view('web.draw',$data);

                        }else{

                            $rotation   = Fibonanci::rotation($draw->prize_id);
                            
                            //update ticket
                            SpinVoucher::where('voucher',$request->voucher)->update([
                                "status" => 'used',
                            ]);


                            SpinDraw::where('id',$draw->id)->update([
                                "rotation" => $rotation,
                                'status'   => 'used'
                            ]);

                            //save history
                            SpinHistory::create([
                                "id"        => (string) Str::uuid(),
                                "date"      => date('Y-m-d'),
                                "draw_id"   => $draw->id,
                                "prize_id"  => $draw->prize_id
                            ]);

                            //return to index

                            $data['faq']       = SpinFaq::listData();
                            $data['history']   = SpinHistory::listData();
                            $data['prize']     = SpinPrize::orderBy('sorter','asc')->get();
                            $data['total']     = SpinPrize::count();
                            $data['spin' ]     = "true";
                            $data['rotation']  = $rotation;
                            $data['result']    = $draw->prize_id;
                            $data['draw_id']   = $draw->id;
                            $data['duration']  = 20;

                            return view('web.draw',$data);

                        }


                    }else{
                        return redirect()->back()->with('message','code sudah expired')->with('message_type','danger');
                    }

                }else{
                    return redirect()->back()->with('message','ticket tidak di temukan')->with('message_type','danger');
                }


            }else{
                return redirect()->back()->with('message','code sudah digunakan')->with('message_type','danger');
            }


        }else{
            return redirect()->back()->with('message','code atau username tidak ditemukan, silahkan check kembali')->with('message_type','danger');
        }

        
    }

    public function result($draw_id,$prize_id){

        $data['prize']          = SpinPrize::orderBy('sorter','asc')->get();
        $data['total']          = SpinPrize::count();
        $data['result_prize']   = SpinPrize::where('id',$prize_id)->first();
        $data['result_draw']    = SpinDraw::detailData($draw_id);
        $data['rotation']       = $data['result_draw']->rotation;
        $data['spin']           = 'true';

        return view('web.result',$data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
